<?php

print("This test script has been uploaded to your site by web hosting technical support because of a support request (IDS-5555) for your hosting account.<br><br>");
print("If this test script executes correctly you will see a form below which will allow you to send an email.  Once submitted, if the email was sent successfully you will see an notice stating this.  Otherwise you will see an error describing the failure.<br><br>");
print("<hr>\n");
print("<br>\n");

$hostname = "gmail.com";
$group = "testemail.com";
$case_num = "Test Email";

$To = $_POST['To'];
$subject = $_POST['subject'];
$message = $_POST['message'];
$Submit = $_POST['Submit'];

if($Submit)
{
	// First lets verify each form variable is not null
	if(!(is_not_null($To)))
	{
		$status_msg = "Please enter a To: email address!";
		displayForm($status_msg, $mailTo, $mailFrom, $subject, $message);
		exit();
	}


	if(!(is_not_null($subject)))
	{
		$status_msg = "Please enter a subject for your test email!";
		displayForm($status_msg, $mailTo, $mailFrom, $subject, $message);
		exit();
	}


	if(!(is_not_null($message)))
	{
		$status_msg = "Please enter a message to send in your test email!";
		displayForm($status_msg, $mailTo, $mailFrom, $subject, $message);
		exit();
	}


	// If we have made it this far, lets verify the email addresses
	// entered appear to be in a proper format.

	$mailTo = "$To@$hostname";
	if(!(is_email_valid($mailTo)))
	{
		$status_msg = "The To: address entered does not appear to be a valid email address! Please try again.";
		displayForm($status_msg, $mailTo, $mailFrom, $subject, $message);
		exit();
	}


	$mailFrom = "support@$group";
	if(!(is_email_valid($mailFrom)))
	{
		$status_msg = "The From: address entered does not appear to be a valid email address! Please try again";
		displayForm($status_msg, $mailTo, $mailFrom, $subject, $message);
		exit();
	}


	// If we are here, then we have passed all the variable tests
	// so lets send our test email message.

	$subject = "$case_num - $subject:";

	$success = mail("$mailTo", "$subject", "$message", "From: $mailFrom\n");


	// Lets test for success and then print the appropriate status message.

	if(isset($success))
	{
		$status_msg = "Your test email message has been sent!";
	}
	else
	{
		$status_msg = "There was a problem!  Your message was NOT sent!";
	}


	// We always want to end with displaying the form.  Unless called
	// above, we want to clear out all the form variables.  We should
	// not get this far if there was bad information submited above.
	unset($mailTo);
	unset($mailFrom);
	unset($subject);
	unset($message);
	displayForm($status_msg);
}
else
{
	// Just display the form as nothing has been entered yet.
	displayForm();
}


// All functions needed for this script are listed below.

function displayForm($status_msg = "", $mailTo = "", $mailFrom = "", $subject = "", $message = "")
{
	global $hostname, $group, $To, $case_num;
	print("<p><font color=\"red\"><b>$status_msg</b></font></p>");
	print("<form method=\"post\" action=\"$PHP_SELF\">");
	print("   <table width=\"450\" border=\"0\" align=\"center\">");
	print("      <tr> ");
	print("         <td width=\"75\"> ");
	print("            <div align=\"right\"><b>To:</b></div>");
	print("         </td>");
	print("         <td width=\"365\">");
	print("            <input type=\"text\" name=\"To\" size=\"15\" value=\"$To\"><b>@$hostname</b>");
	print("         </td>");
	print("      </tr>");
	print("      <tr> ");
	print("         <td width=\"75\"> ");
	print("            <div align=\"right\"><b>From:</b></div>");
	print("         </td>");
	print("         <td width=\"365\">");
	print("            support@$group");
	print("         </td>");
	print("      </tr>");
	print("      <tr> ");
	print("         <td width=\"75\"> ");
	print("            <div align=\"right\"><b>Subject:</b></div>");
	print("         </td>");
	print("         <td width=\"365\">");
	print("            $case_num - <input type=\"text\" name=\"subject\" size=\"35\" value=\"$subject\">");
	print("         </td>");
	print("      </tr>");
	print("      <tr> ");
	print("         <td width=\"75\"> ");
	print("            <div align=\"right\"><b>Message:</b></div>");
	print("         </td>");
	print("         <td width=\"365\">");
	print("            <textarea name=\"message\" cols=\"50\" rows=\"4\">$message</textarea>");
	print("         </td>");
	print("      </tr>");
	print("      <tr> ");
	print("         <td width=\"75\"> ");
	print("            <div align=\"right\"><b></b></div>");
	print("         </td>");
	print("         <td width=\"365\">");
	print("            <input type=\"submit\" name=\"Submit\" value=\"Submit\">");
	print("         </td>");
	print("      </tr>");
	print("   </table>");
	print("</form>");
	print("<p>&nbsp;</p>");
}


function is_email_valid($email)
{
	if(eregi("^[a-z0-9\._-]+@+[a-z0-9\._-]+\.+[a-z]{2,3}$", $email)) return TRUE;
	else return FALSE;
}


function is_not_null($value)
{
	if($value != "") return TRUE;
	else return FALSE;
}

?>
