<?php

// include configuration file
include('config.php');
	
// connect to the database
$dbc = @mysqli_connect ($db_host, $db_user, $db_password, $db_name) OR die ('Could not connect to MySQL: ' . mysqli_connect_error());

// continue session
session_start();
	
// check for a user_id
if(!$_SESSION['user_id'])
{
	// redirect user to homepage if they are not signed in
	header("Location: index.php");	
}

// If the form has been submitted, update user information
if(isset($_POST['submit']))
{
	// Create an error array
	$error = array();
	
	// Check for a firstname
	if(empty($_POST['firstname']))
	{
		$error['firstname'] = 'Required field';
	} else {
		$firstname = $_POST['firstname'];
	}
	
	// Check for a lastname
	if(empty($_POST['lastname']))
	{
		$error['lastname'] = 'Required field';
	} else {
		$lastname = $_POST['lastname'];
	}
	
	// Check for a email
	if(empty($_POST['email']))
	{
		$error['email'] = 'Required field';
	} else {
	
		// Check to see if email address is unique
		$query = "select user_id from users where email = '{$_POST['email']}'";
		$result = mysqli_query($dbc, $query);
		$row = mysqli_fetch_assoc($result);
		if(mysqli_num_rows($result) > 0)
		{
			// Check to see if this email address is owned by this user
			if($row['user_id'] != $_SESSION['user_id'])
			{
				$error['email'] = 'This email address is already taken';
			}
		}
		
		$email = $_POST['email'];
	}
	
	// If there are no errors
	if(sizeof($error) == 0)
	{
		// Edit user information in the users table
		$query = "update users set 
						firstname = '{$_POST['firstname']}', 
						lastname = '{$_POST['lastname']}',  
						email = '{$_POST['email']}'
				 	where
				 		user_id = '{$_SESSION['user_id']}'";
		$result = mysqli_query($dbc, $query);
		
		// Redirect user to profile page (with a confirmation)
		header("Location: profile.php?confirmation=profile");
		exit();
				
	} 

// If the form has not been submitted, get user information so that we can fill in the default form values
} else {

	// Get user information
	$query = "SELECT firstname, lastname, email FROM users WHERE user_id = '{$_SESSION['user_id']}'";
	$result = mysqli_query($dbc, $query);
	$row = mysqli_fetch_assoc($result);
	
	// Assign user information to template
	$firstname = $row['firstname'];
	$lastname = $row['lastname'];
	$email = $row['email'];
	$biography = $row['biography'];
	
}

?>

<!DOCTYPE html>
<html>
	<head>
		<title>Shoutbox</title>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" media="screen">
		<link href="bootstrap/css/prettify.css" rel="stylesheet" media="screen">
		<script src="http://code.jquery.com/jquery.js"></script>
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<script src="bootstrap/js/prettify.js"></script>
		
		<script type="text/javascript">
			$(document).ready(function()
			{
				prettyPrint();
			});
		</script>
				
	</head>
	<body>
		
		<!-- top navigation -->
		<?php include('topnavigation.php'); ?>
		
		<!-- content -->	
		<div class="container" style="margin-top: 65px">

			<h2><?php echo "{$_SESSION['firstname']} {$_SESSION['lastname']}"; ?></h2>
			
			<?php
				
				// Display a confirmation message if applicable
				if($_GET['confirmation'] == 'profile')
				{
					echo "<div class=\"alert alert-success\">Your profile has been updated</div>";
				}
			
			?>
			
			<!-- bootstrap row -->
			<div class="row">
			
				<!-- left column -->
				<div class="span3">
				
					<?php
					
						// Check if the user has a profile image on file 
						if(file_exists('photos/' . $_SESSION['user_id'] . '.jpg'))
						{
							// Assign time to prevent image caching
							$timestamp = time();
							
							// If the user has a profile image on file, display the user's profile image
							echo "<img src=\"photos/{$_SESSION['user_id']}.jpg?time={$timestamp}\" class=\"img-rounded\"  style=\"border: 1px solid #ccc; margin-bottom: 25px;\" />";
							
						} else {
						
							// If the user does not have a profile image on file, display a default profile image
							echo "<img src=\"photos/noimage.png\" class=\"img-rounded\" style=\"border: 1px solid #ccc;  margin-bottom: 25px;\" />";
							
						}
					?>
					
					<!-- upload profile photo link -->
					<p><a href="profile-uploadphoto.php" class="btn">Upload Photo</a></p>
				
				</div>
				
				<!-- right column -->
				<div class="span9">
					
					<!-- edit profile form -->
					<form method="post" action="profile.php">
						
						<!-- first name -->
						<label>First Name</label>
						<input name="firstname" type="text" value="<?php echo $firstname; ?>" autocomplete="off" />
						<span class="text-error"><?php echo $error['firstname']; ?></span><br /><br />
						
						<!-- last name -->
						<label>Last Name</label>
						<input name="lastname" type="text" value="<?php echo $lastname; ?>" autocomplete="off" />
						<span class="text-error"><?php echo $error['lastname']; ?></span><br /><br />
						
						<!-- email -->
						<label>Email</label>
						<input name="email" type="text" value="<?php echo $email; ?>" autocomplete="off" />
						<span class="text-error"><?php echo $error['email']; ?></span><br /><br />
	
						<!-- submit button -->
						<input name="submit" type="submit" value="Save" class="btn btn-primary" />
						
					</form>
	
				</div>
			
			</div>
						
		</div>
	
	</body>
</html>