<?php

// include configuration file
include('config.php');

// Include SimpleImage library (http://www.white-hat-web-design.co.uk/articles/php-image-resizing.php)
include('SimpleImage.php');
	
// connect to the database
$dbc = @mysqli_connect ($db_host, $db_user, $db_password, $db_name) OR die ('Could not connect to MySQL: ' . mysqli_connect_error());

// continue session
session_start();
	
// check for a user_id
if(!$_SESSION['user_id'])
{
	// redirect user to homepage if they are not signed in
	header("Location: index.php");	
}

// define photo locations
// it would be better to declare $uploadpath inside of config.php as it is used in other PHP scripts
//$uploadpath = './photos';
$profile_photo = $uploadpath . $_SESSION['user_id'] . '.jpg'; 
$profile_icon  = $uploadpath . $_SESSION['user_id'] . '_icon.jpg';

// If the submit button has been pressed
if(isset($_POST['submit']))
{				
	// Check for a photo
	if(!isset($_FILES['file']['tmp_name']))
	{
		$error['file'] = 'An image file is required';
	}
	
	// Check for valid file type
	if (($_FILES["file"]["type"] == "image/gif")   ||
		($_FILES["file"]["type"] == "image/jpeg")  ||
		($_FILES["file"]["type"] == "image/pjpeg") ||
		($_FILES["file"]["type"] == "image/png"))
	{
		// Image format is ok
	} else {
		$error['file'] = 'Invalid file type (images only)';
	}
	
	// If there are no errors
	if(sizeof($error) == 0)
	{
		// resize and upload large profile image
		$largeimage = new SimpleImage();
	    $largeimage->load($_FILES['file']['tmp_name']);
	    $largeimage->resizeToWidth(200);
	    $largeimage->save($profile_photo);
	    
	    // Resize and upload large profile image
		$thumbimage = new SimpleImage();
	    $thumbimage->load($_FILES['file']['tmp_name']);
	    $thumbimage->resizeToWidth(64);
	    $thumbimage->save($profile_icon);
		
		// Redirect user
		header("Location: profile.php");
		exit();
	
	} 
}

?>

<!DOCTYPE html>
<html>
	<head>
		<title>Shoutbox</title>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" media="screen">
		<link href="bootstrap/css/prettify.css" rel="stylesheet" media="screen">
		<script src="http://code.jquery.com/jquery.js"></script>
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<script src="bootstrap/js/prettify.js"></script>
		
		<script type="text/javascript">
			$(document).ready(function()
			{
				prettyPrint();
			});
		</script>
				
	</head>
	<body>
		
		<!-- top navigation -->
		<?php include('topnavigation.php'); ?>
		
		<!-- content -->	
		<div class="container" style="margin-top: 65px">

			<h2><?php echo "{$_SESSION['firstname']} {$_SESSION['lastname']}"; ?></h2>
			
			<!-- bootstrap row -->
			<div class="row">
			
				<!-- left column -->
				<div class="span3">
				
					<?php
					
						// Check if the user has a profile image on file 
						if(file_exists('photos/' . $_SESSION['user_id'] . '.jpg'))
						{
							// Assign time to prevent image caching
							$timestamp = time();
							
							// If the user has a profile image on file, display the user's profile image
							echo "<img src=\"photos/{$_SESSION['user_id']}.jpg?time={$timestamp}\" class=\"img-rounded\"  style=\"border: 1px solid #ccc; margin-bottom: 25px;\" />";
							
						} else {
						
							// If the user does not have a profile image on file, display a default profile image
							echo "<img src=\"photos/noimage.png\" class=\"img-rounded\" style=\"border: 1px solid #ccc;  margin-bottom: 25px;\" />";
							
						}
					?>
				
				</div>
				
				<!-- right column -->
				<div class="span9">
		
					<!-- upload image form -->
					<form method="post" enctype="multipart/form-data" action="profile-uploadphoto.php">
					
						<!-- file -->
						<label for="file">Image</label>
						<input id="file" name="file" type="file" />
						<span class="text-error"><?php $error['file']; ?></span><br /><br />
						
						<!-- submit button -->
						<input name="submit" type="submit" value="Upload" class="btn btn-primary" />
	
					</form>
	
				</div>
			
			</div>
						
		</div>
	
	</body>
</html>
