<?php

// include configuration file
include('config.php');
	
// connect to the database
$dbc = @mysqli_connect ($db_host, $db_user, $db_password, $db_name) OR die ('Could not connect to MySQL: ' . mysqli_connect_error());

// continue session
session_start();
	
// check for a user_id
if(!$_SESSION['user_id'])
{
	// redirect user to homepage if they are not signed in
	header("Location: index.php");	
}

// it would be better to declare $uploadpath inside of config.php as it is used in other PHP scripts
$uploadpath = '/photos/';

?>
<!DOCTYPE html>
<html>
	<head>
		<title>Shoutbox</title>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" media="screen">
		<link href="bootstrap/css/prettify.css" rel="stylesheet" media="screen">
		<script src="http://code.jquery.com/jquery.js"></script>
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<script src="bootstrap/js/prettify.js"></script>
		
		<script type="text/javascript">
			$(document).ready(function()
			{
				prettyPrint();
			});
		</script>
				
	</head>
	<body>
		
		<!-- top navigation -->
		<?php include('topnavigation.php'); ?>
		
		<!-- content -->	
		<div class="container" style="margin-top: 65px">

			<h2>Welcome <?php echo "{$_SESSION['firstname']} {$_SESSION['lastname']}"; ?>!</h2>
			
			<?php
			
				// check for shout removal
			if($_GET['action'] == 'remove')
			{
				// check ownership
				if($row['user_id'] == $_SESSION['user_id'])
				{
					// delete shout
					$query = "DELETE FROM shouts WHERE shout_id = '{$_GET['id']}' LIMIT 1";
					$result = @mysqli_query($dbc, $query) or die('Query failed: ' . mysqli_error($dbc));
				
					// display confirmation
					echo "<div class=\"alert alert-success\">Your shout has been removed</div>";
				}
			}
			
			// check for shout submission
			if(isset($_POST['submit']))
			{
				// empty error array
				$error = array();
				
				// check for a shout
				if(empty($_POST['shout']))
				{
					$error[] = 'A shout is required';
				}
				
				// if there are no errors, insert shout into the database.
				// otherwise, display errors.
				if(sizeof($error) == 0)
				{
					// insert shout
					$query = "INSERT INTO shouts (shout_id, user_id, shout, shoutdate) VALUES (null, '{$_SESSION['user_id']}', '{$_POST['shout']}', NOW())";
					$result = @mysqli_query($dbc, $query) or die('Query failed: ' . mysqli_error($dbc));
					
					// display confirmation
					echo "<div class=\"alert alert-success\">Your shout has been added</div>";
					
				} else {
					
					// display error message
					foreach($error as $value)
					{
						echo "<div class=\"alert alert-error\">{$value}</div>";
					}
					
				}
			}

			
			?>
			
			<!-- shoutbox form -->
			<form method="post" action="activity.php">
				<textarea name="shout" placeholder="What do you want to say?" class="span12"></textarea><br />
				<input name="submit" type="submit" value="Shout" class="btn btn-primary" />
			</form>
			
			<?php
			
					
			// select all shouts from the database		
			$query = "SELECT shout_id, user_id, shout, DATE_FORMAT(shoutdate,'%M %d, %Y') AS formatted_date FROM shouts ORDER BY shoutdate DESC";
			$result = @mysqli_query($dbc, $query) or die('Query failed: ' . mysqli_error($dbc));
			while ($row = mysqli_fetch_assoc($result)) 
			{
				// get user information
				$query2 = "SELECT user_id, firstname, lastname FROM users WHERE user_id = '{$row['user_id']}'";
				$result2 = mysqli_query($dbc, $query2);
				$row2 = mysqli_fetch_assoc($result2);
			
				
				
				// display shout (two columns - left column display the image; right column displays the text)
				echo "<div class=\"well\">";
				echo "<div class=\"row\">";
				
				// check ownership
				if($row['user_id'] == $_SESSION['user_id'])
				{	
					// delete shout icon
					echo "<a href=\"shoutbox.php?action=remove&id={$row['shout_id']}\" class=\"pull-right\"><i class=\"icon-remove\"></i></a>";
				}
				
				echo "<div class=\"span1\">";
				
				// check for a profile image
				if(file_exists('photos/' . $row['user_id'] . '.jpg'))
				{
					// Assign time to prevent image caching
					$timestamp = time();
					
					// If the user has a profile image on file, display the user's profile image
					echo "<img src=\"photos/{$_SESSION['user_id']}_icon.jpg?time={$timestamp}\" class=\"img-rounded\"  style=\"border: 1px solid #ccc; float: left;\" />";
					
				} else {
				
					// If the user does not have a profile image on file, display a default profile image
					echo "<img src=\"photos/noimage_icon.png\" class=\"img-rounded\" style=\"border: 1px solid #ccc;  float: left; \" />";
					
				}
				
				echo "</div>";
				echo "<div class=\"span9\">";
				
				
				echo "<p><strong>{$row2['firstname']} {$row2['lastname']} writes:</strong></p>";
				echo "<p>{$row['shout']}</p>";
				echo "<span style=\"color: #666\">{$row['formatted_date']}<span>";
				echo "</div>";
				echo "</div>";
				echo "</div>";
			}
		?>

			
		</div>
	
	</body>
</html>
