<?php

// include configuration file
include('config.php');
	
// connect to the database
$dbc = @mysqli_connect ($db_host, $db_user, $db_password, $db_name) OR die ('Could not connect to MySQL: ' . mysqli_connect_error());

// continue session
session_start();

// if the submit button has been pressed
if(isset($_POST['submit']))
{
	// create an empty error array
	$error = array();
	
	// check for a email
	if(empty($_POST['email']))
	{
		$error['email'] = 'Required field';
	} 
	
	// check for a password
	if(empty($_POST['userpass']))
	{
		$error['userpass'] = 'Required field';
	} 
	
	// check signin credentials
	if(!empty($_POST['email']) && !empty($_POST['userpass']))
	{
		// get user_id from the users table
		$query = "SELECT 
					user_id, 
					firstname, 
					lastname 
				FROM 
					users 
				WHERE 
					email = '{$_POST['email']}' AND userpass = sha1('{$_POST['userpass']}') 
				LIMIT 1";
		$result = mysqli_query($dbc, $query);
		$row = mysqli_fetch_assoc($result);
		
		// if the user is not found
		if(!$row['user_id'])
		{
			$error['user'] = 'Invalid username and/or password';
		}
	}
	
	// if there are no errors
	if(sizeof($error) == 0)
	{
		// append user_id to session
		$_SESSION['user_id'] = $row['user_id'];
		$_SESSION['firstname'] = $row['firstname'];
		$_SESSION['lastname'] = $row['lastname'];
		
		// redirect user to profile page
		header("Location: activity.php");
		exit();

	} 
}

?>
<!DOCTYPE html>
<html>
	<head>
		<title>Shoutbox</title>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link href="http://designingsocialplatforms.com/kuiphoff/day07/bootstrap/css/bootstrap.min.css" rel="stylesheet" media="screen">
		<script src="http://code.jquery.com/jquery.js"></script>
		<script src="http://designingsocialplatforms.com/kuiphoff/day07/bootstrap/js/bootstrap.min.js"></script>
	</head>
	<body>
		
		<!-- top navigation -->
		<?php include('topnavigation.php'); ?>
		
		<!-- content -->	
		<div class="container" style="margin-top: 65px">
		
			<h2>Sign in</h2>
			
			<?php
				// check for a user error
				if($error['user'])
				{
					echo "<div class=\"alert alert-error\">{$error['user']}</div>";
				}
			?>
						
			<!-- signin form -->
			<form method="post" action="index.php">
				
				<!-- email -->
				<label>Email</label>
				<input name="email" type="text" value="<?php echo $_POST['email']; ?>" autocomplete="off" />
				<span class="text-error"><?php echo $error['email']; ?></span>
				
				<!-- password -->
				<label for="password">Password</label>
				<input id="password" name="userpass" type="password" autocomplete="off" />
				<span class="text-error"><?php echo $error['userpass']; ?></span><br />
				
				<!-- submit button -->
				<input name="submit" type="submit" value="Sign in" class="btn btn-large btn-primary" />
				
			</form>
			
			<!-- sign up link -->
			<p>Don't already have an account? <a href="signup.php">Sign up</a>!</p>
			
		</div>
	
	</body>
</html>
