<?php

session_start(); 

// Include auth library
$config = 'hybridauth/config.php';
require_once('hybridauth/Hybrid/Auth.php');

// Check for errors
$error = "";
if(isset($_GET["error"]))
{
	die($_GET["error"]);
}

// if user select a provider to login with
if($_GET["provider"])
{
	try
	{
		// create an instance for Hybridauth with the configuration file path as parameter
		$hybridauth = new Hybrid_Auth($config);

		// set selected provider name 
		$provider = @trim(strip_tags($_GET["provider"]));

		// try to authenticate the selected $provider
		$adapter = $hybridauth->authenticate($provider);
		
		// Get access token
		$access_token = $adapter->getAccessToken();

		// Get the user profile
		$user_data = $adapter->getUserProfile();

		// Uncomment last two lines to get all information
		//print_r($user_data);
		//exit();

		// Add access token to session variables
		$_SESSION['access_token'] = $access_token['access_token'];

		// Add user information to session variables
		$_SESSION['firstname'] = $user_data->firstName;
		$_SESSION['lastname'] = $user_data->lastName;
		$_SESSION['displayname'] = $user_data->displayName;
		$_SESSION['email'] = $user_data->email;
		$_SESSION['website'] = $user_data->webSiteURL;
		$_SESSION['photo'] = $user_data->photoURL;
		$_SESSION['website'] = $user_data->webSiteURL;
		$_SESSION['profile'] = $user_data->profileURL;
		$_SESSION['provider_id'] = $user_data->identifier;
		$_SESSION['provider'] = $_GET['provider'];
		
		// Redirect to the welcome page
		header("Location: welcome.php");
		exit();
		
	}
	catch(Exception $e)
	{
		// Display error 
		switch( $e->getCode() )
		{ 
			case 0 : $error = "Unspecified error."; break;
			case 1 : $error = "Hybriauth configuration error."; break;
			case 2 : $error = "Provider not properly configured."; break;
			case 3 : $error = "Unknown or disabled provider."; break;
			case 4 : $error = "Missing provider application credentials."; break;
			case 5 : $error = "Authentification failed. The user has canceled the authentication or the provider refused the connection."; break;
			case 6 : $error = "User profile request failed. Most likely the user is not connected to the provider and he should to authenticate again."; 
				     $adapter->logout(); 
				     break;
			case 7 : $error = "User not connected to the provider."; 
				     $adapter->logout(); 
				     break;
		} 
		
		die($e->getMessage());
	}
}

?>

<!DOCTYPE html>
<html>
	<head>
		<title>Facebook Authentication</title>
	</head>
	<body>
		<p><a href="index.php?provider=Facebook">Sign in using Facebook</a></p>
	</body>
</html>
