<?php

// include configuration file
include('config.php');
	
// connect to the database
$dbc = @mysqli_connect ($db_host, $db_user, $db_password, $db_name) OR die ('Could not connect to MySQL: ' . mysqli_connect_error());

// continue session
session_start();

// if the form has been submitted
if(isset($_POST['submit']))
{
	// create an empty error array
	$error = array();

	// check for a firstname
	if(empty($_POST['firstname']))
	{
		$error['firstname'] = 'Required field';
	} 
	
	// check for a lastname
	if(empty($_POST['lastname']))
	{
		$error['lastname'] = 'Required field';
	} 
	
	// check for a email
	if(empty($_POST['email']))
	{
		$error['email'] = 'Required field';
	} else {
	
		// check to see if email address is unique
		$query = "select user_id from users where email = '{$_POST['email']}'";
		$result = mysqli_query($dbc, $query);
		if(mysqli_num_rows($result) > 0)
		{
			$error['email'] = 'You already have an account';
		}
	}
	
	// check for a password
	if(empty($_POST['userpass']))
	{
		$error['userpass'] = 'Required field';
	} 
	
	// if there are no errors
	if(sizeof($error) == 0)
	{
		// insert user into the users table
		$query = "INSERT INTO baggyGenesUsers (
					user_id, 
					firstname, 
					lastname, 
					email, 
					userpass,
					signupdate
				) VALUES (
					null,
					'{$_POST['firstname']}',
					'{$_POST['lastname']}',
					'{$_POST['email']}',
					sha1('{$_POST['userpass']}'),
					NOW()
					)";
		$result = mysqli_query($dbc, $query);
		
		// obtain user_id from table
		$user_id = mysqli_insert_id($dbc);
		
		// send a signup e-mail to user
		$message = "Dear {$_POST['firstname']} {$_POST['lastname']},\n";
		$message = $message . "Thank you for signing up!\n";
		mail($_POST['email'], 'Sign up confirmation', $message, "From: admin@designingsocialplatforms.com");
		
		// append user_id to session array
		$_SESSION['user_id'] = $user_id;
		$_SESSION['firstname'] = $_POST['firstname'];
		$_SESSION['lastname'] = $_POST['lastname'];
		
		// redirect user to profile page
		header("Location: activity.php");
		exit();
				
	} 
}

?>
<!DOCTYPE html>
<html>
	<head>
		<title>Shoutbox</title>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link href="http://designingsocialplatforms.com/kuiphoff/day07/bootstrap/css/bootstrap.min.css" rel="stylesheet" media="screen">
		<script src="http://code.jquery.com/jquery.js"></script>
		<script src="http://designingsocialplatforms.com/kuiphoff/day07/bootstrap/js/bootstrap.min.js"></script>			
	</head>
	<body>
		
		<!-- top navigation -->
		<?php include('topnavigation.php'); ?>
		
		<!-- content -->	
		<div class="container" style="margin-top: 65px">
		
			<h2>Sign up</h2>

			<!-- signup form -->
			<form method="post" action="signup.php">
				
				<!-- first name -->
				<label>First Name</label>
				<input name="firstname" type="text" value="<?php echo $_POST['firstname']; ?>" autocomplete="off" />
				<span class="text-error"><?php echo $error['firstname']; ?></span>
								
				<!-- last name -->
				<label>Last Name</label>
				<input name="lastname" type="text" value="<?php echo $_POST['lastname']; ?>" autocomplete="off" />
				<span class="text-error"><?php echo $error['lastname']; ?></span>
				
				<!-- e-mail -->
				<label>E-mail</label>
				<input name="email" type="text" value="<?php echo $_POST['email']; ?>" autocomplete="off" />
				<span class="text-error"><?php echo $error['email']; ?></span>
				
				<!-- password -->
				<label>Password</label>
				<input name="userpass" type="password"  autocomplete="off" />
				<span class="text-error"><?php echo $error['userpass']; ?></span><br /><br />
				
				<!-- submit button -->
				<input name="submit" type="submit" value="Sign up" class="btn btn-large btn-primary"" />
				
			</form>
			
			<!-- sign in link -->
			<p>Already have an account? <a href="index.php">Sign in</a>!</p>
			
		</div>
	
	</body>
</html>
