<!DOCTYPE html>
<html>
	<head>
		<title>Question / Answer</title>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link href="http://www.designingsocialplatforms.com/kuiphoff/day05/bootstrap/css/bootstrap.min.css" rel="stylesheet" media="screen">
		<script src="http://code.jquery.com/jquery.js"></script>
		<script src="http://www.designingsocialplatforms.com/kuiphoff/day05/bootstrap/js/bootstrap.min.js"></script>  
	</head>
	<body>
  
	<div class="navbar navbar-inverse navbar-fixed-top">
		<div class="navbar-inner">
			<div class="container">
				<a class="brand" href="#">Question / Answer</a>
			</div>
		</div>
	</div>
  
	<div class="container" style="margin-top: 65px">
 
		<h2>Question / Answer</h2>
 
		<?php
		  
			// Include database credentials
			include("config.php");
		  
			// Connect to the database
			$dbc = @mysqli_connect ($db_host, $db_user, $db_password, $db_name) OR die ('Could not connect to MySQL: ' . mysqli_connect_error());
		  
			// If the submit button has been pressed
			if(isset($_POST['submit']))
			{
				// Empty error array
				$error = array();
		  
				// Check for a question
				if(empty($_POST['question']))
				{
					$error['question'] = 'A question is required.';
				} 
		  
				// If there are no errors
				if(sizeof($error) == 0)
				{
					// Insert a record into the database
					$query = "INSERT INTO questions (
						question_id, 
						question, 
						submitdate
					) VALUES (
						null, 
						'{$_POST['question']}', 
						NOW()
					)";
					mysqli_query($dbc, $query);
		  
					// Display a confirmation
					echo "<div class=\"alert alert-success\">Your question has been saved.</div>";
		  
				} else {
		  
					foreach($error as $value)
					{
						echo "<div class=\"alert alert-error\">";
						echo $value; 
						echo "</div>";
					}
				}
			}
		  
		?>
		  
		<!-- Questions form -->
		<form method="post" action="questions.php">
			<textarea name="question" placeholder="What is your question?" rows="3" class="span12"></textarea>
			<input type="submit" name="submit" value="Save" class="btn btn-primary" />
		</form>
	  
		<!-- Questions table -->
		<table class="table">
			<thead>
				<tr>
					<th>Question</th>
					<th>Date</th>
					<th>Responses</th>
				</tr>
			</thead>
			<tbody>
		  
		  		<?php
		  
					// Select questions from the database
					$query = "SELECT 
						question_id, 
						question, 
						DATE_FORMAT(submitdate, '%M %d, %Y') AS formatteddate 
					FROM 
						questions 
					ORDER BY 
						submitdate DESC";
					$result = mysqli_query($dbc, $query);
					while ($row = mysqli_fetch_assoc($result)) 
					{
						// Select the number of answers from the database
						$query2 = "SELECT * FROM answers WHERE question_id = '{$row['question_id']}'";
						$result2 = mysqli_query($dbc, $query2);
						$responses = mysqli_num_rows($result2);
			  
						// Print out questions and number of answers
						echo "<tr>";
						echo "<td><a href=\"answers.php?question={$row['question_id']}\">{$row['question']}</a></td>";
						echo "<td>{$row['formatteddate']}</td>";
						echo "<td>{$responses}</td>";
						echo "</tr>";  
					}
			  
				?>
		  
			</tbody>
		</table>
  
		</div>
		</body>
</html>
