CsvParser parser;
String[][] data;

float origin;
float speed = 0.3f;
int padding = 8;

boolean animate;

int index = 2;
int max_index;
int step = 1;

color button_color = color(180, 180, 180);
float button_left_dist;
float button_right_dist;


void setup() {
size(width, 480);
//size(640, 480);
smooth();
//parser = new CsvParser("http://bl.ocks.org/d/4270069/mobile_resolution-ww-monthly-201112-201212.csv");
parser = new CsvParser("mobile_resolution-ww-monthly-201112-201212.csv");
data = parser.data();
}

void draw() {
background(255);

int max_index = data.length-1;

//strokeWeight(0.5);
//stroke(button_color);
line(15, height-80, width-15, height-80);

fill(button_color); 
noStroke();

textSize(24);
textAlign(LEFT);
text("MOBILE SCREEN", 15, 36); 
textSize(20);
text("RESOLUTIONS", 15, 64); 

textSize(20);
textAlign(CENTER);
fill(100, 170, 255);
text(data[index][0], width/2, height-30); 

fill(button_color);
textSize(12);
textAlign(RIGHT);
text("Data source: StatCounter", width-15, 28  );
text("Period: Jan to Dec 2012", width-15, 48);

// Screen tower animation
if (origin < padding && animate) {
  origin+=speed;
}

for (int i = 0; i < max_index; i++) {
  if (i != 0) {
    // 320x480
    if (i == 2) {
      new Tower(width/2, height-(height/3), int(data[index][i]), data[0][i], 32, 48).display();
    } 
    // 240x320
    if (i == 3) {
      new Tower(width/3.5, height-(height/3), int(data[index][i]), data[0][i], 24, 32).display();
    }
    // 600x800
    if (i == 4) {
      new Tower(width/14, height-(height/3), int(data[index][i]), data[0][i], 60, 80).display();
    }
    // 480x800
    if (i == 7) {
      new Tower(width-(width/3.5), height-(height/3), int(data[index][i]), data[0][i], 48, 80).display();
    }
    // 720x1280
    if (i == 8) {
      new Tower(width-(width/12), height-(height/3), int(data[index][i]), data[0][i], 72, 128).display();
    }
  }
}

new Button(35, height-40, "left").display();
button_left_dist = dist(35, height-40, mouseX, mouseY);

new Button(width-35, height-40, "right").display();
button_right_dist = dist(width-35, height-40, mouseX, mouseY);
}

class Button {

float buttonX;
float buttonY;
String orientation;

Button(float _buttonX, float _buttonY, String _orientation) {
  buttonX = _buttonX;
  buttonY = _buttonY;
  orientation = _orientation;
}

void display() {
  pushMatrix();
  translate(buttonX, buttonY);
  strokeWeight(3);
  stroke(button_color);
  noFill();
  ellipse(0, 0, 40, 40);
  noStroke();
  fill(button_color);
  textSize(24);
  textAlign(CENTER);
  if (orientation == "left") {
    triangle(-10, 0, 6, 8, 6, -8);
  } 
  else if (orientation == "right") {
    triangle(10, 0, -6, -8, -6, 8);
  }
  popMatrix();

  pushMatrix();
  translate(buttonX, buttonY);

  popMatrix();
}
}

void mouseClicked() {
if (button_left_dist < 20) {
  if (index > 2) {
    index-=step;
  }
} 
else if (button_right_dist < 20) {
  if (index < 13) {
    index+=step;
  }
}

if (button_left_dist < 20 || button_right_dist < 20) {
  if (origin > padding) {
    origin = 0;
    animate = true;
  }
}
}

class Tower {

float towerOriginX;
float towerOriginY;
float amount;
String screenSizeLabel;
int screenSizeWidth;
int screenSizeHeight;

int base = 0;

Tower(float _towerOriginX, float _towerOriginY, float _amount, String _screenSizeLabel, int _screenSizeWidth, int _screenSizeHeight) {
  towerOriginX = _towerOriginX;
  towerOriginY = _towerOriginY;
  amount = _amount;
  screenSizeLabel = _screenSizeLabel;
  screenSizeWidth = _screenSizeWidth;
  screenSizeHeight = _screenSizeHeight;
}

void display() {
  animate = true;

  fill(button_color);
  noStroke();
  pushMatrix();
  translate(towerOriginX, towerOriginY);
  textSize(24);
  textAlign(LEFT);
  text(amount+"%", -screenSizeWidth/2, 36);
  textSize(12);
  text(screenSizeLabel, -screenSizeWidth/2, 56);
  popMatrix();

  stroke(255);
  fill(button_color);

  pushMatrix();
  translate(towerOriginX, towerOriginY);
  //rotateX(radians(45));
  rectMode(CENTER);
  rect(0, -screenSizeHeight/2, screenSizeWidth, screenSizeHeight);
  strokeWeight(1);
  popMatrix();

  stroke(255);
  fill(0, 140, 220);

  for (int i = 0; i < amount; i++) { 
    pushMatrix();
    translate(towerOriginX, towerOriginY-=origin);
    rectMode(CENTER);
    rect(0, -screenSizeHeight/2, screenSizeWidth, screenSizeHeight);
    strokeWeight(1);
    popMatrix();
  }
}
}

class CsvParser {

String lines[];
String[][] csv;
int csvWidth;

CsvParser(String file) { 
  lines = loadStrings(file);
  csvWidth=0;
}


String [][] data() {

  //calculate max width of csv file 
  for (int i = 0; i < lines.length; i++) {
    String [] chars=split(lines[i], ',');
    if (chars.length>csvWidth) {
      csvWidth=chars.length;
    }
  }

  //create csv array based on # of rows and columns in csv file
  csv = new String [lines.length][csvWidth];

  //parse values into 2d array
  for (int i=0; i < lines.length; i++) {
    String [] temp = new String [lines.length];
    temp= split(lines[i], ',');
    for (int j=0; j < temp.length; j++) {
      csv[i][j]=temp[j];
    }
  }

  return csv;
}
}

// Include the resize function
void resize(float w) {
width = Math.round(w);
}
